# 機能設計書 99-VB REPL (vbi)

## 概要

本ドキュメントは、Visual Basic Interactive (vbi) コマンドラインツールの機能設計を定義する。vbi は、Visual Basic コードを対話的に実行するための REPL (Read-Eval-Print Loop) 環境を提供するコマンドラインアプリケーションである。

### 本機能の処理概要

vbi.exe は、コマンドラインから Visual Basic コードを対話的に入力・実行できる環境を提供する。C# の csi.exe と同様の機能を Visual Basic 言語で提供し、VB 開発者に対話的な実行環境を提供する。

**業務上の目的・背景**：Visual Basic を使用する開発者に対して、csi と同等の対話的実行環境を提供する。VB コードのプロトタイピングや学習に使用できる。

**機能の利用シーン**：
- コマンドラインでの対話的 VB コード実行
- VB スクリプトファイルの実行
- VB API の動作確認やプロトタイピング

**主要な処理内容**：
1. コマンドライン引数のパース
2. レスポンスファイル（vbi.rsp）の読み込み
3. スクリプトファイルの実行またはインタラクティブモードの開始
4. REPL ループによる対話的実行
5. 結果の表示とフォーマット

**関連システム・外部連携**：.NET SDK、VB スクリプトエンジン（VisualBasicScript）。

**権限による制御**：csi と同様。

## 関連画面

本機能はコンソールアプリケーションであり、コマンドライン UI を使用する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コンソール | 主画面 | 対話的コード入力と結果表示 |

## 機能種別

コマンドラインツール / REPL / スクリプト実行

## 入力仕様

### コマンドライン引数

| 引数 | 説明 | 例 |
|-----|------|-----|
| <script> | 実行するスクリプトファイル | `vbi script.vbx` |
| -r:<reference> | アセンブリ参照の追加 | `vbi -r:Newtonsoft.Json.dll` |
| -imports:<namespace> | Imports ディレクティブの追加 | `vbi -imports:System.IO` |
| -i | インタラクティブモードで開始 | `vbi -i` |
| -- <args> | スクリプトに渡す引数 | `vbi script.vbx -- arg1 arg2` |
| -help | ヘルプの表示 | `vbi -help` |
| -version | バージョンの表示 | `vbi -version` |

### 入力データソース

- コマンドライン引数
- 標準入力（インタラクティブモード）
- スクリプトファイル
- レスポンスファイル（vbi.rsp）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | 文字列 | フォーマットされた実行結果 |
| エラーメッセージ | 文字列 | コンパイルエラーや実行時エラー |
| 終了コード | Integer | 0: 成功、1: エラー |

### 出力先

- 標準出力（結果）
- 標準エラー出力（エラー）

## 処理フロー

### 処理シーケンス

```
1. エントリーポイント
   └─ Vbi.Main(args)
2. 初期設定
   └─ BuildPaths 構築、レスポンスファイル読み込み
3. コンパイラ初期化
   └─ VisualBasicInteractiveCompiler 作成
4. ランナー初期化
   └─ CommandLineRunner 作成
5. 実行モード判定
   └─ スクリプトファイル指定 or インタラクティブモード
6. 実行
   └─ RunInteractive または RunScript
7. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[vbi.exe 起動] --> B[BuildPaths 構築]
    B --> C[vbi.rsp 読み込み]
    C --> D[VisualBasicInteractiveCompiler 作成]
    D --> E[CommandLineRunner 作成]
    E --> F{バージョン/ヘルプ表示?}
    F -->|Yes| G[表示して終了]
    F -->|No| H{スクリプトファイル指定?}
    H -->|Yes| I[RunScript]
    H -->|No| J[RunInteractiveLoop]
    I --> K{エラー?}
    K -->|Yes| L[終了コード 1]
    K -->|No| M[終了コード = 戻り値]
    J --> N[REPL ループ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-01 | レスポンスファイル | vbi.rsp からデフォルト参照とインポートを読み込み | 常に |
| BR-99-02 | スクリプト引数 | -- 以降の引数をスクリプトの Args として渡す | スクリプト実行時 |
| BR-99-03 | 共通ランナー使用 | CommandLineRunner は csi と共有 | 常に |

### 計算ロジック

csi と同様、終了コードはスクリプトの戻り値または例外の HResult を返す。

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | コンパイルエラー | 構文エラーまたは型エラー | コードを修正 |
| 1 | スクリプトファイル不正 | 複数ファイル指定または非スクリプト | 1つのファイルを指定 |
| - | 実行時例外 | スクリプト実行中のエラー | 例外表示 |

### リトライ仕様

インタラクティブモードではエラー後も入力を継続可能。

## トランザクション仕様

トランザクション不要。

## パフォーマンス要件

csi と同様。

## セキュリティ考慮事項

csi と同様。

## 備考

vbi は csi ほど広く使用されていないが、VB 開発者向けの同等機能を提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Vbi.vb | `src/Interactive/vbi/Vbi.vb` | Main エントリーポイント |

**主要処理フロー**:
- **12行目**: InteractiveResponseFileName = "vbi.rsp"
- **14-43行目**: Main 関数
- **18行目**: vbi ディレクトリの取得
- **20-24行目**: BuildPaths 構築
- **26-30行目**: VisualBasicInteractiveCompiler 作成
- **32-36行目**: CommandLineRunner 作成
- **38行目**: runner.RunInteractive() 呼び出し

**読解のコツ**: VB 構文に注意。`New` キーワード、`:=` による名前付き引数など。

#### Step 2: VB インタラクティブコンパイラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VisualBasicInteractiveCompiler.vb | `src/Scripting/VisualBasic/Hosting/VisualBasicInteractiveCompiler.vb` | VB 対話型コンパイラ |

#### Step 3: 共通コマンドラインランナーを理解する

csi (No.98) と同じ CommandLineRunner を使用するため、詳細は No.98 を参照。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs` | 共通 REPL ランナー |

### プログラム呼び出し階層図

```
Vbi.Main(args)
    │
    └─ New CommandLineRunner(console, compiler, scriptCompiler, objectFormatter)
           │
           └─ RunInteractive()
                  └─ RunInteractiveCore(errorLogger)
                         │
                         ├─ スクリプト指定時
                         │      └─ RunScript(options, code, errorLogger)
                         │
                         └─ インタラクティブ時
                                └─ RunInteractiveLoop(options, initialCode)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

コマンドライン引数 ───────▶ VisualBasicInteractiveCompiler ──▶ ParseOptions
      │                            │
      ▼                            ▼
vbi.rsp ───────────────────▶ ScriptOptions ─────────────────▶ 参照/Imports
      │                            │
      ▼                            ▼
stdin ──────────────────────▶ ReadLine() ──────────────────▶ SourceText
      │                            │
      ▼                            ▼
                         Script.Create/Compile/Run ─────────▶ ScriptState
                                   │
                                   ▼
                         VisualBasicObjectFormatter ────────▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Vbi.vb | `src/Interactive/vbi/` | ソース | エントリーポイント |
| vbi.rsp | `src/Interactive/vbi/` | 設定 | デフォルト参照とインポート |
| VisualBasicInteractiveCompiler.vb | `src/Scripting/VisualBasic/Hosting/` | ソース | VB 対話型コンパイラ |
| CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/` | ソース | 共通 REPL ランナー |
| VisualBasicObjectFormatter.vb | `src/Scripting/VisualBasic/Hosting/ObjectFormatting/` | ソース | 結果フォーマッター |
| ConsoleIO.cs | `src/Scripting/Core/Hosting/CommandLine/` | ソース | コンソール入出力 |
| InteractiveScriptGlobals.cs | `src/Scripting/Core/Hosting/` | ソース | グローバルオブジェクト |
